/*  phpBB3 Style Sheet
    --------------------------------------------------------------
	Style name:			subsilver2
	Based on style:		subSilver (the default phpBB 2.0.x style)
	Original author:	Tom Beddard ( http://www.subblue.com/ )
	Modified by:		phpBB Group ( http://www.phpbb.com/ )
    --------------------------------------------------------------
*/

/* Layout
 ------------ */
* {
	/* Reset browsers default margin, padding and font sizes */
	margin: 0;
	padding: 0;
}

html {
	font-size: 100%;
}

body {
	/* Text-Sizing with ems: http://www.clagnut.com/blog/348/ */
	font-family: "Lucida Grande", Verdana, Helvetica, Arial, sans-serif;
	color: #323D4F;
	background-color: #FFFFFF;
	/* font-size: 62.5%; */ /* This sets the default font size to be equivalent to 10px */
	font-size: 12px;
	margin: 0;
}

#wrapheader {
	height: auto !important;
	padding: 0;
}

#wrapcentre {
	margin: 15px 25px 0 25px;
}

#wrapfooter {
	text-align: center;
	clear: both;
}

#wrapnav {
	width: 100%;
	margin: 0;
	background-color: #ECECEC;
	border-width: 1px;
	border-style: solid;
	border-color: #A9B8C2;
}

#logodesc {
	background-color: #C1CAD2;
	background-image: url('styles/subsilver2/theme/images/background.gif');
	background-repeat: repeat-x;
	background-position: center bottom;
	padding: 0 25px 15px 25px;
}

#menubar {
	margin: 0 25px;
}

#datebar {
	margin: 10px 25px 0 25px;
}

#findbar {
	width: 100%;
	margin: 0;
	padding: 0;
	border: 0;
}

.forumrules {
	background-color: #F9CC79;
	border-width: 1px;
	border-style: solid;
	border-color: #BB9860;
	padding: 4px;
	font-weight: normal;
	font-size: 1.1em;
	font-family: "Lucida Grande", Verdana, Arial, Helvetica, sans-serif;
}

.forumrules h3 {
	color: red;
}

#pageheader { }
#pagecontent { }
#pagefooter { }

#poll { }
#postrow { }
#postdata { }


/*  Text
 --------------------- */
h1 {
	color: black;
	font-family: "Lucida Grande", "Trebuchet MS", Verdana, sans-serif;
	font-weight: bold;
	font-size: 1.8em;
	text-decoration: none;
}

h2 {
	font-family: Arial, Helvetica, sans-serif;
	font-weight: bold;
	font-size: 1.5em;
	text-decoration: none;
	line-height: 120%;
}

h3 {
	font-size: 1.3em;
	font-weight: bold;
	font-family: Arial, Helvetica, sans-serif;
	line-height: 120%;
}

h4 {
	margin: 0;
	font-size: 1.1em;
	font-weight: bold;
}

p {
	font-size: 1.1em;
}

p.moderators {
	margin: 0;
	float: left;
	color: black;
	font-weight: bold;
}

.rtl p.moderators {
	float: right;
}

p.linkmcp {
	margin: 0;
	float: right;
	white-space: nowrap;
}

.rtl p.linkmcp {
	float: left;
}

p.breadcrumbs {
	margin: 0;
	float: left;
	color: black;
	font-weight: bold;
	white-space: normal;
	font-size: 1em;
}

.rtl p.breadcrumbs {
	float: right;
}

p.datetime {
	margin: 0;
	float: right;
	white-space: nowrap;
	font-size: 1em;
}

.rtl p.datetime {
	float: left;
}

p.searchbar {
	padding: 2px 0;
	white-space: nowrap;
} 

p.searchbarreg {
	margin: 0;
	float: right;
	white-space: nowrap;
}

.rtl p.searchbarreg {
	float: left;
}

p.forumdesc {
	padding-bottom: 4px;
}

p.topicauthor {
	margin: 1px 0;
}

p.topicdetails {
	margin: 1px 0;
}

.postreported, .postreported a:link, .postreported a:visited, .postreported a:hover, .postreported a:active {
	margin: 1px 0;
	color: red;
	font-weight:bold;
}

.postapprove, .postapprove a:link, .postapprove a:visited, .postapprove a:hover, .postapprove a:active {
	color: green;
	font-weight:bold;
}

.postapprove img, .postreported img {
	vertical-align: bottom;
	padding-top: 5px;
}

.postauthor {
	color: #000000;
}

.postdetails {
	color: #000000;
}

.postbody {
	font-size: 1.3em;
	line-height: 1.4em;
	font-family: "Lucida Grande", "Trebuchet MS", Helvetica, Arial, sans-serif;
}

.postbody li, ol, ul {
	margin: 0 0 0 1.5em;
}

.rtl .postbody li, .rtl ol, .rtl ul {
	margin: 0 1.5em 0 0;
}

.posthilit {
	background-color: yellow;
}

.nav {
	margin: 0;
	color: black;
	font-weight: bold;
}

.pagination {
	padding: 4px;
	color: black;
	font-size: 1em;
	font-weight: bold;
}

.cattitle {

}

.gen {
	margin: 1px 1px;
	font-size: 1.2em;
}

.genmed {
	margin: 1px 1px;
	font-size: 1.1em;
}

.gensmall {
	margin: 1px 1px;
	font-size: 1em;
}

.copyright {
	color: #444;
	font-weight: normal;
	font-family: "Lucida Grande", Verdana, Arial, Helvetica, sans-serif;
}

.titles {
	font-family: "Lucida Grande", Helvetica, Arial, sans-serif;
	font-weight: bold;
	font-size: 1.3em;
	text-decoration: none;
}

.error {
	color: red;
}


/* Tables
 ------------ */
th {
	color: #FFA34F;
	font-size: 1.1em;
	font-weight: bold;
	background-color: #006699;
	background-image: url('styles/subsilver2/theme/images/cellpic3.gif');
	white-space: nowrap;
	padding: 7px 5px;
}

td {
	padding: 2px;
}
td.profile {
	padding: 4px;
}

.tablebg {
	background-color: #A9B8C2;
}

.catdiv {
	height: 28px;
	margin: 0;
	padding: 0;
	border: 0;
	background: white url('styles/subsilver2/theme/images/cellpic2.jpg') repeat-y scroll top left;
}
.rtl .catdiv {
	background: white url('styles/subsilver2/theme/images/cellpic2_rtl.jpg') repeat-y scroll top right;
}

.cat {
	height: 28px;
	margin: 0;
	padding: 0;
	border: 0;
	background-color: #C7D0D7;
	background-image: url('styles/subsilver2/theme/images/cellpic1.gif');
	text-indent: 4px;
}

.row1 {
	background-color: #ECECEC;
	padding: 4px;
}

.row2 {
	background-color: #DCE1E5;
	padding: 4px;
}

.row3 {
	background-color: #C0C8D0;
	padding: 4px;
}

.spacer {
	background-color: #D1D7DC;
}

hr {
	height: 1px;
	border-width: 0;
	background-color: #D1D7DC;
	color: #D1D7DC;
}

.legend {
	text-align:center;
	margin: 0 auto;
}

/* Links
 ------------ */

/* Links adjustment to correctly display an order of rtl/ltr mixed content */
.rtl a {
	direction: rtl;
	unicode-bidi: embed;
}

/* CSS spec requires a:link, a:visited, a:hover and a:active rules to be specified in this order. */
/* See http://www.phpbb.com/bugs/phpbb3/59685 */
a:link {
	color: #006597;
	text-decoration: none;
}

a:visited {
	color: #005784;
	text-decoration: none;
}

a:hover {
	color: #D46400;
	text-decoration: underline;
}

a:active {
	color: #005784;
	text-decoration: none;
}

a.forumlink {
	color: #069;
	font-weight: bold;
	font-family: "Lucida Grande", Helvetica, Arial, sans-serif;
	font-size: 1.2em;
}

a.topictitle {
	margin: 1px 0;
	font-family: "Lucida Grande", Helvetica, Arial, sans-serif;
	font-weight: bold;
	font-size: 1.2em;
}

a.topictitle:visited {
	color: #5493B4;
	text-decoration: none;
}

th a,
th a:visited {
	color: #FFA34F !important;
	text-decoration: none;
}

th a:hover {
	text-decoration: underline;
}


/* Form Elements
 ------------ */
form {
	margin: 0;
	padding: 0;
	border: 0;
}

input {
	color: #333333;
	font-family: "Lucida Grande", Verdana, Helvetica, sans-serif;
	font-size: 1.1em;
	font-weight: normal;
	padding: 1px;
	border: 1px solid #A9B8C2;
	background-color: #FAFAFA;
}

textarea {
	background-color: #FAFAFA;
	color: #333333;
	font-family: "Lucida Grande", Verdana, Helvetica, Arial, sans-serif;
	font-size: 1.3em; 
	line-height: 1.4em;
	font-weight: normal;
	border: 1px solid #A9B8C2;
	padding: 2px;
}

select {
	color: #333333;
	background-color: #FAFAFA;
	font-family: "Lucida Grande", Verdana, Helvetica, sans-serif;
	font-size: 1.1em;
	font-weight: normal;
	border: 1px solid #A9B8C2;
	padding: 1px;
}

option {
	padding: 0 1em 0 0;
}

option.disabled-option {
	color: graytext;
}

.rtl option {
	padding: 0 0 0 1em;
}

input.radio {
	border: none;
	background-color: transparent;
}

.post {
	background-color: white;
	border-style: solid;
	border-width: 1px;
}

.btnbbcode {
	color: #000000;
	font-weight: normal;
	font-size: 1.1em;
	font-family: "Lucida Grande", Verdana, Helvetica, sans-serif;
	background-color: #EFEFEF;
	border: 1px solid #666666;
}

.btnmain {
	font-weight: bold;
	background-color: #ECECEC;
	border: 1px solid #A9B8C2;
	cursor: pointer;
	padding: 1px 5px;
	font-size: 1.1em;
}

.btnlite {
	font-weight: normal;
	background-color: #ECECEC;
	border: 1px solid #A9B8C2;
	cursor: pointer;
	padding: 1px 5px;
	font-size: 1.1em;
}

.btnfile {
	font-weight: normal;
	background-color: #ECECEC;
	border: 1px solid #A9B8C2;
	padding: 1px 5px;
	font-size: 1.1em;
}

.helpline {
	background-color: #DEE3E7;
	border-style: none;
}


/* BBCode
 ------------ */
.quotetitle, .attachtitle {
	margin: 10px 5px 0 5px;
	padding: 4px;
	border-width: 1px 1px 0 1px;
	border-style: solid;
	border-color: #A9B8C2;
	color: #333333;
	background-color: #A9B8C2;
	font-size: 0.85em;
	font-weight: bold;
}

.quotetitle .quotetitle {
	font-size: 1em;
}

.quotecontent, .attachcontent {
	margin: 0 5px 10px 5px;
	padding: 5px;
	border-color: #A9B8C2;
	border-width: 0 1px 1px 1px;
	border-style: solid;
	font-weight: normal;
	font-size: 1em;
	line-height: 1.4em;
	font-family: "Lucida Grande", "Trebuchet MS", Helvetica, Arial, sans-serif;
	background-color: #FAFAFA;
	color: #4B5C77;
}

.attachcontent {
	font-size: 0.85em;
}

.codetitle {
	margin: 10px 5px 0 5px;
	padding: 2px 4px;
	border-width: 1px 1px 0 1px;
	border-style: solid;
	border-color: #A9B8C2;
	color: #333333;
	background-color: #A9B8C2;
	font-family: "Lucida Grande", Verdana, Helvetica, Arial, sans-serif;
	font-size: 0.8em;
}

.codecontent {
	direction: ltr;
	margin: 0 5px 10px 5px;
	padding: 5px;
	border-color: #A9B8C2;
	border-width: 0 1px 1px 1px;
	border-style: solid;
	font-weight: normal;
	color: #006600;
	font-size: 0.85em;
	font-family: Monaco, 'Courier New', monospace;
	background-color: #FAFAFA;
}

.syntaxbg {
	color: #FFFFFF;
}

.syntaxcomment {
	color: #FF8000;
}

.syntaxdefault {
	color: #0000BB;
}

.syntaxhtml {
	color: #000000;
}

.syntaxkeyword {
	color: #007700;
}

.syntaxstring {
	color: #DD0000;
}


/* Private messages
 ------------------ */
.pm_marked_colour {
	background-color: #000000;
}

.pm_replied_colour {
	background-color: #A9B8C2;
}

.pm_friend_colour {
	background-color: #007700;
}

.pm_foe_colour {
	background-color: #DD0000;
}


/* Misc
 ------------ */
img {
	border: none;
}

.sep {
	color: black;
	background-color: #FFA34F;
}

table.colortable td {
	padding: 0;
}

pre {
	font-size: 1.1em;
	font-family: Monaco, 'Courier New', monospace;
}

.nowrap {
	white-space: nowrap;
}

.username-coloured {
	font-weight: bold;
}